package r01mo.model.search.query.metadata;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import r01f.enums.EnumWithCode;
import r01f.enums.EnumWithCodeWrapper;
import r01f.types.annotations.Inmutable;
import r01mo.model.oids.R01MMetaDataOID;

@Inmutable
@Accessors(prefix="_",fluent=true)
@NoArgsConstructor(access=AccessLevel.PRIVATE)
public class R01MSearchQueryOrderByMetaData implements R01MSearchQueryModelObject {
	private static final long serialVersionUID = -7697135676510549009L;
/////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Identificador del metadato por el que se ordena
	 */
	@Getter 		private R01MMetaDataOID _metaDataOid;
	/**
	 * Orden
	 */
	@Getter @Setter private R01MSearchQueryOrderBy _order;
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	public static R01MSearchQueryOrderByMetaData forMetaData(final R01MMetaDataOID oid) {
		R01MSearchQueryOrderByMetaData outMD = new R01MSearchQueryOrderByMetaData();
		outMD._metaDataOid = oid;
		return outMD;
	}
	public static R01MSearchQueryOrderByMetaData forMetaData(final String oid) {
		return R01MSearchQueryOrderByMetaData.forMetaData(R01MMetaDataOID.forId(oid));
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  ENUM
/////////////////////////////////////////////////////////////////////////////////////////
	@Accessors(prefix="_")
	@RequiredArgsConstructor
	public static enum R01MSearchQueryOrderBy implements EnumWithCode<String,R01MSearchQueryOrderBy> {
		ASCENDING	("ASC"),
		DESCENDING	("DESC");
		
		@Getter private final String _code;
		private static EnumWithCodeWrapper<String,R01MSearchQueryOrderBy> _enums = new EnumWithCodeWrapper<String,R01MSearchQueryOrderBy>(R01MSearchQueryOrderBy.values());
	
		@Override
		public boolean isIn(R01MSearchQueryOrderBy... status) {
			return _enums.isIn(this,status);
		}
		@Override
		public boolean is(R01MSearchQueryOrderBy other) {
			return _enums.is(this,other);
		}
	}
}
