package r01mo.model.search.query.metadata;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.experimental.Accessors;
import r01f.enums.EnumWithCode;
import r01f.enums.EnumWithCodeWrapper;

/**
 * Condiciones de FILTRO sobre meta-datos de tipo numerico
 */
@Accessors(prefix="_")
@RequiredArgsConstructor(access=AccessLevel.PRIVATE)
public enum R01MSearchQueryNumberMetaDataCondition implements R01MSearchQueryMetaDataCondition<R01MSearchQueryNumberMetaDataCondition>,
															  EnumWithCode<String,R01MSearchQueryNumberMetaDataCondition> {
	EQUALS			(1,"EQ"),
	NOT_EQUALS		(1,"NEQ"),
	LESS			(1,"LT"),
	GREATER			(1,"GT"),
	LESS_OR_EQUAL	(1,"LTE"),
	GREATER_OR_EQUAL(1,"GTE"),
	BETWEEN			(2,"BETWEEN"),
	IN				(-1,"IN"),
	NOT_IN			(-1,"NOT_IN");
/////////////////////////////////////////////////////////////////////////////////////////
//  INTERFAZ R01MSearchQueryMetaDataCondition
/////////////////////////////////////////////////////////////////////////////////////////
			private final int _requiredNumberOfArguments;
	@Getter private final String _code;
	@Override
	public int requiredNumberOfArguments() {
		return _requiredNumberOfArguments;
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  INTERFAZ EnumWithCode
/////////////////////////////////////////////////////////////////////////////////////////
	private static EnumWithCodeWrapper<String,R01MSearchQueryNumberMetaDataCondition> _enums = new EnumWithCodeWrapper<String,R01MSearchQueryNumberMetaDataCondition>(R01MSearchQueryNumberMetaDataCondition.values());

	@Override
	public boolean isIn(R01MSearchQueryNumberMetaDataCondition... status) {
		return _enums.isIn(this,status);
	}
	@Override
	public boolean is(R01MSearchQueryNumberMetaDataCondition other) {
		return _enums.is(this,other);
	}
}
