package r01mo.model.search.query.metadata;

import r01mo.model.oids.R01MMetaDataOID;


/**
 * MetaDato de tipo number
 * <code>
 *		R01MSearchQueryLongMetaData md = R01MSearchQueryLongMetaData.forMetaData(R01MMetaDataOID.forId("aMetaData"))
 *																	.usingCondition(R01MSearchQueryNumberMetaDataCondition.EQUALS)
 *																	.with(2);
 * </code>
 */
public class R01MSearchQueryNumberMetaData extends R01MSearchQueryMetaDataBase<R01MSearchQueryNumberMetaDataCondition,Number> {
	private static final long serialVersionUID = -4571361639782333325L;
/////////////////////////////////////////////////////////////////////////////////////////
//  FLUENT API CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	public static R01MSearchQueryMetaDataWithoutCondition<R01MSearchQueryNumberMetaDataCondition,Number> forMetaData(final R01MMetaDataOID metaDataOid) {
		R01MSearchQueryNumberMetaData outMetaData = new R01MSearchQueryNumberMetaData();
		outMetaData.setMetaDataOid(metaDataOid);
		return outMetaData.new R01MSearchQueryMetaDataWithoutCondition<R01MSearchQueryNumberMetaDataCondition,Number>(outMetaData);
	}
	public static R01MSearchQueryMetaDataWithoutCondition<R01MSearchQueryNumberMetaDataCondition,Number> forMetaData(final String metaDataOid) {
		return R01MSearchQueryNumberMetaData.forMetaData(R01MMetaDataOID.forId(metaDataOid));
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
/////////////////////////////////////////////////////////////////////////////////////////	
	@Override
	protected String valueToString(final Number value) {
		return value != null ? value.toString() : null;
	}
}
