package r01mo.model.search.query.metadata;

import java.util.Iterator;
import java.util.Set;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import r01f.enums.EnumWithCode;
import r01f.util.types.Strings;
import r01f.util.types.collections.CollectionUtils;
import r01mo.model.oids.R01MMetaDataOID;

import com.google.common.collect.Sets;

@Accessors(prefix="_")
public abstract class R01MSearchQueryMetaDataBase<C extends R01MSearchQueryMetaDataCondition<C>,T> implements R01MSearchQueryMetaData {
	private static final long serialVersionUID = 8876315003604309677L;
/////////////////////////////////////////////////////////////////////////////////////////
//  
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Identificador del metadato
	 */
	@Getter @Setter(AccessLevel.PACKAGE) R01MMetaDataOID _metaDataOid;
	/**
	 * Condicin sobre el metaDatao
	 */
	@Getter @Setter(AccessLevel.PACKAGE) C _condition;
	/**
	 * Valor del metaDato
	 */
	@Getter @Setter(AccessLevel.PACKAGE) Set<T> _values;
/////////////////////////////////////////////////////////////////////////////////////////
//  INTERFAZ R01MSearchQueryMetaData
/////////////////////////////////////////////////////////////////////////////////////////
	@Override
	public R01MMetaDataOID getOid() {
		return _metaDataOid;
	}
	@Override @SuppressWarnings("unchecked")
	public String getConditionAsString() {
		return _condition != null ? ((EnumWithCode<String,C>)_condition).getCode() : null;
	}
	@Override
	public String getValueAsString() {
		if (_values == null) return null;
    	StringBuilder sb = new StringBuilder();
    	for (Iterator<T> it = _values.iterator(); it.hasNext(); ) {
    		sb.append(valueToString(it.next()));
    		if (it.hasNext()) sb.append(",");
    	}
    	return sb.toString();
	}
	/**
	 * Convierte un valor en formato String
	 * @param value el valor a convertir
	 * @return el valor convertido en cadena
	 */
	protected abstract String valueToString(final T value);
	
/////////////////////////////////////////////////////////////////////////////////////////
//  CLASES AUXILIARES PARA EL BUILDER FLUENT-API
/////////////////////////////////////////////////////////////////////////////////////////
	@RequiredArgsConstructor
	public class R01MSearchQueryMetaDataWithoutCondition<C1 extends R01MSearchQueryMetaDataCondition<C1>,T1> implements R01MSearchQueryModelObject {
		private static final long serialVersionUID = 2001500739646693286L;
		private final R01MSearchQueryMetaDataBase<C1,T1> _metaData;
		/**
		 * Establece la condicin sobre el metaDato
		 * @param condition la condicin
		 * @return 
		 */
		public R01MSearchQueryMetaDataWithoutValue<C1,T1> usingCondition(final C1 condition) {
			_metaData.setCondition(condition);
			return new R01MSearchQueryMetaDataWithoutValue<C1,T1>(_metaData);
		}
	}
	@RequiredArgsConstructor
	public class R01MSearchQueryMetaDataWithoutValue<C1 extends R01MSearchQueryMetaDataCondition<C1>,T1> implements R01MSearchQueryModelObject {
		private static final long serialVersionUID = 1168638094706531184L;
		private final R01MSearchQueryMetaDataBase<C1,T1> _metaData;
		/**
		 * Establece los valores de la condicin asegurndose de que el nmero coincide con lo esperado en la condicin
		 * y que viene dado por el mtodo requiredNumberOfArguments de la condicin
		 * @param values los valores posibles de la condicin
		 * @return
		 */
		@SuppressWarnings("unchecked")
		public <R extends R01MSearchQueryMetaDataBase<C1,T1>> R with(final T1... values) {
			// Comprobaciones de seguridad
			if (_metaData.getCondition() == null) throw new IllegalStateException("Call forMetaData factory and usingCondition before setting metaData values");
			if (_metaData.getCondition().requiredNumberOfArguments() >= 0 && _metaData.getCondition().requiredNumberOfArguments() != values.length) {
				throw new IllegalArgumentException(Strings.of("If the condition is {} the 'with' method arguments must be {} {}")
														  .customizeWith(_metaData.getCondition(),_metaData.getCondition().requiredNumberOfArguments(),values.getClass().getName())
														  .asString());
			}
			_metaData.setValues(Sets.newHashSet(values));
			return (R)_metaData;
		}
	}
}
