package r01mo.model.search.query.metadata;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.experimental.Accessors;
import r01f.enums.EnumWithCode;
import r01f.enums.EnumWithCodeWrapper;

/**
 * Condiciones de filtro sobre meta-datos de tipo literal (aquellos que han de coincidir exactamente)
 */
@Accessors(prefix="_")
@RequiredArgsConstructor(access=AccessLevel.PRIVATE)
public enum R01MSearchQueryLiteralMetaDataCondition implements R01MSearchQueryMetaDataCondition<R01MSearchQueryLiteralMetaDataCondition>,
															   EnumWithCode<String,R01MSearchQueryLiteralMetaDataCondition> {
	EQUALS	(1,"EQ"),
	IN		(-1,"IN");
/////////////////////////////////////////////////////////////////////////////////////////
//  INTERFAZ R01MSearchQueryMetaDataCondition
/////////////////////////////////////////////////////////////////////////////////////////
			private final int _requiredNumberOfArguments;
	@Getter private final String _code;
	
	@Override
	public int requiredNumberOfArguments() {
		return _requiredNumberOfArguments;
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  INTERFAZ EnumWithCode
/////////////////////////////////////////////////////////////////////////////////////////
	private static EnumWithCodeWrapper<String,R01MSearchQueryLiteralMetaDataCondition> _enums = new EnumWithCodeWrapper<String,R01MSearchQueryLiteralMetaDataCondition>(R01MSearchQueryLiteralMetaDataCondition.values());

	@Override
	public boolean isIn(R01MSearchQueryLiteralMetaDataCondition... status) {
		return _enums.isIn(this,status);
	}
	@Override
	public boolean is(R01MSearchQueryLiteralMetaDataCondition other) {
		return _enums.is(this,other);
	}
}
