package r01mo.model.search.query.metadata;

import java.io.Serializable;

import r01mo.model.oids.R01MMetaDataOID;


/**
 * MetaDato de tipo texto
 * <code>
 *		R01MSearchQueryLiteralMetaData md = R01MSearchQueryLiteralMetaData.forMetaData(R01MMetaDataOID.forId("aMetaData"))
 *																		  .usingCondition(R01MSearchQueryLiteralMetaDataCondition.EQUALS)
 *																		  .with("a string");
 *		// Incluso se puede utilizar un literal tipo Int
 *		R01MSearchQueryLiteralMetaData md2 = R01MSearchQueryLiteralMetaData.forMetaData(R01MMetaDataOID.forId("aMetaData"))
 *																		  .usingCondition(R01MSearchQueryLiteralMetaDataCondition.EQUALS)
 *																		  .with(2);
 * </code>
 */
public class R01MSearchQueryLiteralMetaData extends R01MSearchQueryMetaDataBase<R01MSearchQueryLiteralMetaDataCondition,Serializable> {
	private static final long serialVersionUID = -4571361639782333325L;
/////////////////////////////////////////////////////////////////////////////////////////
//  FLUENT API CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	public static R01MSearchQueryMetaDataWithoutCondition<R01MSearchQueryLiteralMetaDataCondition,Serializable> forMetaData(final R01MMetaDataOID metaDataOid) {
		R01MSearchQueryLiteralMetaData outMetaData = new R01MSearchQueryLiteralMetaData();
		outMetaData.setMetaDataOid(metaDataOid);
		return outMetaData.new R01MSearchQueryMetaDataWithoutCondition<R01MSearchQueryLiteralMetaDataCondition,Serializable>(outMetaData);
	}
	public static R01MSearchQueryMetaDataWithoutCondition<R01MSearchQueryLiteralMetaDataCondition,Serializable> forMetaData(final String metaDataOid) {
		return R01MSearchQueryLiteralMetaData.forMetaData(R01MMetaDataOID.forId(metaDataOid));
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
/////////////////////////////////////////////////////////////////////////////////////////	
	@Override
	protected String valueToString(final Serializable value) {
		return value != null ? value.toString() : null;
	}
}
