package r01mo.model.search.query.metadata;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.experimental.Accessors;
import r01f.enums.EnumWithCode;
import r01f.enums.EnumWithCodeWrapper;

/**
 * Condiciones de filtro sobre meta-datos de tipo fecha
 */
@Accessors(prefix="_")
@RequiredArgsConstructor(access=AccessLevel.PRIVATE)
public enum R01MSearchQueryDateMetaDataCondition implements R01MSearchQueryMetaDataCondition<R01MSearchQueryDateMetaDataCondition>,
															EnumWithCode<String,R01MSearchQueryDateMetaDataCondition> {
	SAME			(1,"EQ"),
	NOT_SAME		(1,"NEQ"),
	AFTER			(1,"GT"),
	BEFORE			(1,"LT"),
	AFTER_OR_SAME	(1,"GTE"),
	BEFORE_OR_SAME	(1,"LTE"),
	BETWEEN			(2,"BETWEEN"),
	IN				(-1,"IN"),
	NOT_INT			(-1,"NOT_IN");
/////////////////////////////////////////////////////////////////////////////////////////
//  INTERFAZ R01MSearchQueryMetaDataCondition
/////////////////////////////////////////////////////////////////////////////////////////
			private final int _requiredNumberOfArguments;
	@Getter private final String _code;
	@Override
	public int requiredNumberOfArguments() {
		return _requiredNumberOfArguments;
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  INTERFAZ EnumWithCode
/////////////////////////////////////////////////////////////////////////////////////////
	private static EnumWithCodeWrapper<String,R01MSearchQueryDateMetaDataCondition> _enums = new EnumWithCodeWrapper<String,R01MSearchQueryDateMetaDataCondition>(R01MSearchQueryDateMetaDataCondition.values());

	@Override
	public boolean isIn(R01MSearchQueryDateMetaDataCondition... status) {
		return _enums.isIn(this,status);
	}
	@Override
	public boolean is(R01MSearchQueryDateMetaDataCondition other) {
		return _enums.is(this,other);
	}	
}
