package r01mo.model.search.query.metadata;

import java.util.Date;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;
import r01f.util.types.Dates;
import r01mo.model.oids.R01MMetaDataOID;


/**
 * MetaDato de tipo fecha
 * <code>
 *		R01MSearchQueryDateMetaData md = R01MSearchQueryDateMetaData.forMetaData(R01MMetaDataOID.forId("aMetaData"))
 *																	.usingCondition(R01MSearchQueryDateMetaDataCondition.AFTER)
 *																	.with(new Date());
 * </code>
 */
@NoArgsConstructor(access=AccessLevel.PRIVATE)
public class R01MSearchQueryDateMetaData extends R01MSearchQueryMetaDataBase<R01MSearchQueryDateMetaDataCondition,Date> {
	private static final long serialVersionUID = -2844887576134012223L;
/////////////////////////////////////////////////////////////////////////////////////////
//  FLUENT API CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	public static R01MSearchQueryMetaDataWithoutCondition<R01MSearchQueryDateMetaDataCondition,Date> forMetaData(final R01MMetaDataOID metaDataOid) {
		R01MSearchQueryDateMetaData outMetaData = new R01MSearchQueryDateMetaData();
		outMetaData.setMetaDataOid(metaDataOid);
		return outMetaData.new R01MSearchQueryMetaDataWithoutCondition<R01MSearchQueryDateMetaDataCondition,Date>(outMetaData);
	}
	public static R01MSearchQueryMetaDataWithoutCondition<R01MSearchQueryDateMetaDataCondition,Date> forMetaData(final String metaDataOid) {
		return R01MSearchQueryDateMetaData.forMetaData(R01MMetaDataOID.forId(metaDataOid));
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
/////////////////////////////////////////////////////////////////////////////////////////	
	@Override
	protected String valueToString(final Date value) {
		return value != null ? Dates.format(value,"yyyy/MM/dd") : null;
	}	
}

