package r01mo.model.search.query.facets;

import java.util.Collection;

import r01mo.model.oids.R01MMetaDataOID;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;

/**
 * Clase base para la especificacin de un facet del que se pueden especificar rangos de los
 * que se quiere devolver valores 
 * @param <T> el tipo de dato del metaDato
 */
public abstract class R01MSearchQueryRangedMetaDataFacet<T extends Comparable<T>> extends R01MSearchQueryFacetBase<R01MMetaDataOID> {
	private static final long serialVersionUID = -4948238269424155121L;
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	public R01MSearchQueryRangedMetaDataFacet(R01MMetaDataOID oid) {
		super(oid);
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  ESTADO
/////////////////////////////////////////////////////////////////////////////////////////	
	private Collection<Range<T>> _ranges;
/////////////////////////////////////////////////////////////////////////////////////////
//  FLUENT-API
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Aade uno o varios ranges (constraints) al facet
	 * @param ranges los ranges a aadir
	 */
	@SuppressWarnings("unchecked")
	public <R extends R01MSearchQueryRangedMetaDataFacet<T>> R constrainedToRanges(final Range<T>... ranges) {
		if (ranges == null) return (R)this;
		for (Range<T> r : ranges) this.constrainedToRange(r);
		return (R)this;
	}
	/**
	 * Aade un nuevo range (constraint) al facet
	 * @param range el rango a aadir 
	 */
	@SuppressWarnings("unchecked")
	public <R extends R01MSearchQueryRangedMetaDataFacet<T>> R constrainedToRange(final Range<T> range) {
		if (range == null) return (R)this;
		if (_ranges == null) {
			_ranges = Lists.newArrayList(range);
		} else {
			// Ver si el range se puede interseccionar con otro
			// Ej: El rango 12/10/2012 - 15/10/2012  y el rango 13-10/2012 - 30/10/2012
			//	   se pueden unir en un solo rango: 12/10/2012 - 30-10-2012
			Function<Range<T>,Range<T>> linkerF = new Function<Range<T>,Range<T>>() {
															@Override
															public Range<T> apply(Range<T> r) {
																return r.isConnected(range) ? r.intersection(range)
																							: r;
															}
														};
			_ranges = Collections2.transform(_ranges,linkerF);
		}
		return (R)this;
	}
}
