package r01mo.model.search.query.facets;

import r01mo.model.oids.R01MMetaDataOID;

/**
 * Facet en un metaDato de tipo long y sobre el cual se pueden especificar constraints en rangos para
 * que se devuelvan datos del facet nicamente en los rangos especificados
 * <code>
 *		R01MSearchQueryLongMetaDataFacet facet = R01MSearchQueryLongMetaDataFacet.forMetaData("myLong")
 *																			     .constrainedToRanges(Ranges.closed(1L,25L),
 *																						 	          Ranges.atLeast(3L))
 *																				 .filteringBy(R01MSearchQuery.create().mustHaveStructureLabel("labelOid"));
 * </code>
 * NOTA: Cuando dos rangos se superponen (como en el ejemplo), se unen en uno solo
 */
public class R01MSearchQueryLongMetaDataFacet extends R01MSearchQueryRangedMetaDataFacet<Long> {
	private static final long serialVersionUID = 654240287621169169L;
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	private R01MSearchQueryLongMetaDataFacet(final R01MMetaDataOID metaDataOid) {
		super(metaDataOid);
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR ESTATICO
/////////////////////////////////////////////////////////////////////////////////////////
	public static R01MSearchQueryLongMetaDataFacet forMetaData(final R01MMetaDataOID metaDataOid) {
		R01MSearchQueryLongMetaDataFacet outFacet = new R01MSearchQueryLongMetaDataFacet(metaDataOid);
		return outFacet;
	}
	public static R01MSearchQueryLongMetaDataFacet forMetaData(final String metaDataOid) {
		return R01MSearchQueryLongMetaDataFacet.forMetaData(R01MMetaDataOID.forId(metaDataOid));
	}
}