package r01mo.model.search.query.facets;

import r01mo.model.oids.R01MMetaDataOID;

/**
 * Facet en un metaDato de tipo float y sobre el cual se pueden especificar constraints en rangos para
 * que se devuelvan datos del facet nicamente en los rangos especificados
 * <code>
 *		R01MSearchQueryFloatMetaDataFacet facet = R01MSearchQueryFloatMetaDataFacet.forMetaData("myFloat")
 *																			       .constrainedToRanges(Ranges.closed(1F,25.0F),
 *																						 	            Ranges.atLeast(10F))
 *																				   .filteringBy(R01MSearchQuery.create().mustHaveStructureLabel("labelOid"));
 * </code>
 * NOTA: Cuando dos rangos se superponen (como en el ejemplo), se unen en uno solo
 */
public class R01MSearchQueryFloatMetaDataFacet extends R01MSearchQueryRangedMetaDataFacet<Float> {
	private static final long serialVersionUID = 3592197010207902044L;
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	private R01MSearchQueryFloatMetaDataFacet(final R01MMetaDataOID metaDataOid) {
		super(metaDataOid);
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR ESTATICO
/////////////////////////////////////////////////////////////////////////////////////////
	public static R01MSearchQueryFloatMetaDataFacet forMetaData(final R01MMetaDataOID metaDataOid) {
		R01MSearchQueryFloatMetaDataFacet outFacet = new R01MSearchQueryFloatMetaDataFacet(metaDataOid);
		return outFacet;
	}
	public static R01MSearchQueryFloatMetaDataFacet forMetaData(final String metaDataOid) {
		return R01MSearchQueryFloatMetaDataFacet.forMetaData(R01MMetaDataOID.forId(metaDataOid));
	}
}