package r01mo.model.search.query.facets;

import lombok.experimental.Accessors;
import r01mo.model.oids.R01MOID;
import r01mo.model.search.query.R01MSearchQuery;

/**
 * Base para los tipos de Facets
 * @param <T> el tipo del oid que define el facet
 * 			  puede ser:
 * 			  <pre>
 * 				- un metaDato: {@link r01mo.model.oids.R01MMetaDataOID}
 * 				- un eje de catalogacin: {@link r01mo.model.oids.R01MStructureOID}
 * 				- una tipologa {@link r01mo.model.R01MTypology}
 * 			  </pre>
 */
@Accessors(prefix="_")
public abstract class R01MSearchQueryFacetBase<T extends R01MOID> implements R01MSearchQueryFacetModelObject {
	private static final long serialVersionUID = 3483225188855128486L;
/////////////////////////////////////////////////////////////////////////////////////////
//  ESTADO
/////////////////////////////////////////////////////////////////////////////////////////	
	/**
	 * Identificador del campo que hace de Facet
	 */
	final T _oid;
	/**
	 * Filtro para los valores devueltos en el facet
	 * Este filtro es necesario por ejemplo para facets en estructuras de catalogacin:
	 * <pre>
	 * En la BBDD del buscador hay un field que contiene las catalogaciones de cada 
	 * estructura en un determinado nivel
	 * Ej: Para la estructura 	dpto1	               	
	 *  							|_vice1				
	 *   							|	|_dir1		
	 *   							|_vice2
	 * 	   								|_dir2
	 * 							dpto2
	 * 	  							|_vice3
	 * 									|_dir3
	 * 									|_dir4
	 * los campos de facets en la BBDD "linearizan" cada nivel:
	 * 		estructuraGV_nivel1 = dpto1,dpto2...
	 * 		estructuraGV_nivel2 = vice1,vice2,vice3,...
	 *		estructuraGV_nivel3 = dir1,dir2,dir3,dir4,...
	 * y se "pierde" la jerarqua, de forma que cuando se hace una facet query de nivel 3, devuelve
	 * todas las direcciones, independientemente de la viceconsejera o depto al que pertenecen.
	 * 
	 * Para devolver nicamente las direcciones de una determinada viceconsejera hay que aadir
	 * una condicin de filtro a la facetQuery por ejemplo label=vice3, de forma que SOLO se van
	 * a devolver dir3 y dir4
	 * </pre> 
	 */
	R01MSearchQuery _filter;
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	public R01MSearchQueryFacetBase(final T oid) {
		_oid = oid;
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  FLUENT API
/////////////////////////////////////////////////////////////////////////////////////////
	@SuppressWarnings("unchecked")
	public <R extends R01MSearchQueryFacetBase<T>> R filteringBy(final R01MSearchQuery filter) {
		_filter = filter;
		return (R)this;
	}
}
