package r01mo.model.search.query.facets;

import java.util.Date;

import r01mo.model.oids.R01MMetaDataOID;
import r01mo.model.search.query.R01MSearchQuery;

import com.google.common.collect.Ranges;

/**
 * Facet en un metaDato de tipo fecha y sobre el cual se pueden especificar constraints en rangos para
 * que se devuelvan datos del facet nicamente en los rangos especificados
 * <code>
 *		R01MSearchQueryDateMetaDataFacet facet = R01MSearchQueryDateMetaDataFacet.forMetaData("myDate")
 *																				 .constrainedToRanges(Ranges.closed(new Date(System.currentTimeMillis()),new Date(System.currentTimeMillis()+1000)),
 *																						 		      Ranges.atLeast(new Date()))
 *																				 .filteringBy(R01MSearchQuery.create().mustHaveStructureLabel("labelOid"));;
 * </code>
 * NOTA: Cuando dos rangos se superponen (como en el ejemplo), se unen en uno solo
 */
public class R01MSearchQueryDateMetaDataFacet extends R01MSearchQueryRangedMetaDataFacet<Date> {
	private static final long serialVersionUID = -7221251307109719900L;
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	private R01MSearchQueryDateMetaDataFacet(final R01MMetaDataOID metaDataOid) {
		super(metaDataOid);
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR ESTATICO
/////////////////////////////////////////////////////////////////////////////////////////
	public static R01MSearchQueryDateMetaDataFacet forMetaData(final R01MMetaDataOID metaDataOid) {
		R01MSearchQueryDateMetaDataFacet outFacet = new R01MSearchQueryDateMetaDataFacet(metaDataOid);
		return outFacet;
	}
	public static R01MSearchQueryDateMetaDataFacet forMetaData(final String metaDataOid) {
		return R01MSearchQueryDateMetaDataFacet.forMetaData(R01MMetaDataOID.forId(metaDataOid));
	}
}
