package r01mo.model.publisher;

import java.util.Calendar;
import java.util.Date;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;
import r01mo.model.oids.publisher.R01MPublisherOperationOID;
import r01mo.model.publish.R01MPublishModelObject;
import r01mo.model.publish.R01MPublishStatus;

/**
 * Informacin sobre el estado de publicacin en un repositorio
 */
@ConvertToDirtyStateTrackable
@Accessors(prefix="_")
@NoArgsConstructor
public class R01MPublisherOperationResult implements R01MPublishModelObject {
	private static final long serialVersionUID = 5355732790401483696L;
///////////////////////////////////////////////////////////////////////////////////////////
//  ESTADO
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Identificador que el publicador (openDeploy) asign a la operacin de publicacion.
     */
    @Getter @Setter private R01MPublisherOperationOID _publisherOperationOid;
    /**
     * Fecha de la publicacin/despublicacin.
     */
    @Getter @Setter private Date _operationDate = Calendar.getInstance().getTime();
    /**
     * Estado de la operacin de publicacin
     */
    @Getter @Setter private R01MPublishStatus _status;
    /**
     * Confirmacin del publicador
     */
    @Getter @Setter private R01MPublisherConfirmation _publisherConfirmation;
    
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
///////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Comprueba si el objeto est DESPUBLICADO y hay confirmacin de ello
	 * @return true si se trata de un estado de despublicacin
	 */
	public boolean isUnPublished() {
		return _status != null ? _status.isUnPublished()
							   : false;
	}
	/**
	 * Comprueba si el objeto est en proceso de despublicacin
	 * @return
	 */
	public boolean isUnPublishing() {
		return _status != null ? _status.isUnPublishing()
							   : false;
	}
	/**
	 * Comprueba si el objeto est PUBLICADO y hay confirmacin de ello 
	 * @return true si se trata de un estado de despublicacin
	 */
	public boolean isPublished() {
		return _status != null ? _status.isPublished()
							   : false;
	}
	/**
	 * Comprueba si el objeto est en proceso de publicacin
	 * @return
	 */
	public boolean isPublishing() {
		return _status != null ? _status.isPublishing()
							   : false;
	}
	/**
	 * Comprueba si la operacin de publicacin en el objeto ha fallado
	 * @return true si la operacin ha fallado
	 */
	public boolean hasFailed() {
		return _status != null ? _status.hasFailed()
							   : false;
	}
	/**
	 * Comprueba si la operaci'on de publicaci'on en el objeto est'a en ejecucin
	 * @return true si la operacin est en ejecucin
	 */
	public boolean isRunning() {
		return _status != null ? _status.isRunning()
							   : false;
	}
}
