package r01mo.model.publisher;

import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.experimental.Accessors;
import r01f.enums.EnumWithCode;
import r01f.enums.EnumWithCodeWrapper;

/**
 * Confirmacin del publicador sobre el resultado de una publicacin
 */
@Accessors(prefix="_")
@RequiredArgsConstructor
public enum R01MPublisherConfirmation implements EnumWithCode<Integer,R01MPublisherConfirmation> {
	NOT_CONFIRMED(0),	// Antes de llamar al publicador
	CONFIRMED(1);		// Publicacin confirmada
	
	@Getter private final Integer _code;
/////////////////////////////////////////////////////////////////////////////////////////
//  INTERFAZ EnumWithCode
/////////////////////////////////////////////////////////////////////////////////////////
	private static EnumWithCodeWrapper<Integer,R01MPublisherConfirmation> _enums = new EnumWithCodeWrapper<Integer,R01MPublisherConfirmation>(R01MPublisherConfirmation.values());
	
	@Override
	public boolean isIn(R01MPublisherConfirmation... other) {
		return _enums.isIn(this,other);
	}
	@Override
	public boolean is(R01MPublisherConfirmation other) {
		return _enums.is(this,other);
	}
}
