package r01mo.model.publish;

import r01f.enums.EnumExtended;
import r01f.enums.EnumExtendedWrapper;

/**
 * Tipos de peticin de publicacin
 */
public enum R01MPublishType implements EnumExtended<R01MPublishType> {
	INMEDIATE_PUB,		// Publicacin inmediata
	SCHEDULLED_PUB,		// Publicacin programada
	INMEDIATE_UNPUB,	// Despublicacin inmediata
	SCHEDULLED_UNPUB;	// Despublicacin programada
	
	private static EnumExtendedWrapper<R01MPublishType> _enums = new EnumExtendedWrapper<R01MPublishType>(R01MPublishType.values());
	
	@Override
	public boolean isIn(R01MPublishType... other) {
		return _enums.isIn(this,other);
	}
	@Override
	public boolean is(R01MPublishType other) {
		return _enums.is(this,other);
	}
	/**
	 * @return true si se trata de un tipo de despublicacin
	 */
	public boolean isUnPub() {
		return this.isIn(INMEDIATE_UNPUB,SCHEDULLED_UNPUB);
	}
	/**
	 * @return true si se trata de una publicacin/despublicacin programada
	 */
	public boolean isSchedulled() {
		return this.isIn(SCHEDULLED_PUB,SCHEDULLED_UNPUB);
	}
}
