package r01mo.model.publish;

import r01f.enums.EnumExtended;
import r01f.enums.EnumExtendedWrapper;

/**
 * Estados de publicacin
 */
public enum R01MPublishStatus implements EnumExtended<R01MPublishStatus> {
	PUBLISH_OPERATION_OK,				// Publicacin finalizada
	UNPUBLISH_OPERATION_OK,				// Despublicacin finalizada
	PUBLISH_OPERATION_FAILED,			// Publicacin fallida
	UNPUBLISH_OPERATION_FAILED,			// Despublicacin fallida
	PUBLISH_OPERATION_RUNNING,			// Publicacin en ejecucin
	UNPUBLISH_OPERATION_RUNNING;		// Despublicacin en ejecucin

	private static EnumExtendedWrapper<R01MPublishStatus> _enums = new EnumExtendedWrapper<R01MPublishStatus>(R01MPublishStatus.values());
	
	@Override
	public boolean isIn(R01MPublishStatus... status) {
		return _enums.isIn(this,status);
	}
	@Override
	public boolean is(R01MPublishStatus other) {
		return _enums.is(this,other);
	}	
	/**
	 * Comprueba si el estado es de despublicacin confirmada
	 * @return true si se trata de un estado de despublicacin
	 */
	public boolean isUnPublished() {
		return this.is(UNPUBLISH_OPERATION_OK);
	}
	/**
	 * Comprueba si la operacin de de publicacin en curso
	 * @return
	 */
	public boolean isUnPublishing() {
		return this.is(R01MPublishStatus.UNPUBLISH_OPERATION_RUNNING);
	}
	/**
	 * Comprueba si el estado es de publicacin confirmada 
	 * @return true si se trata de un estado de despublicacin
	 */
	public boolean isPublished() {
		return this.is(PUBLISH_OPERATION_OK);
	}
	/**
	 * Comprueba si la operacin de de publicacin en curso
	 * @return
	 */
	public boolean isPublishing() {
		return this.is(R01MPublishStatus.PUBLISH_OPERATION_RUNNING);
	}
	/**
	 * Comprueba si la operacin de publicacin / despublicacin est en EJECUCION
	 * @return true si la operacin an est en ejecucin
	 */
	public boolean isRunning() {
		return this.isIn(PUBLISH_OPERATION_RUNNING,UNPUBLISH_OPERATION_RUNNING);
	}
	/**
	 * Comprueba si la operacin de publicacin / despublicacin ha FALLADO
	 * @return true si la operacin ha fallado
	 */
	public boolean hasFailed() {
		return this.isIn(PUBLISH_OPERATION_FAILED,UNPUBLISH_OPERATION_FAILED);
	}
}
