package r01mo.model.publish;

import java.util.Calendar;
import java.util.Date;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;
import r01mo.model.oids.publish.R01MPublishDestinationRepositoryOID;
import r01mo.model.oids.publish.R01MPublishRequestOID;
import r01mo.model.url.R01MUrl;

/**
 * Publicacin pendiente de ser realizada
 */
@ConvertToDirtyStateTrackable
@Accessors(prefix="_")
@NoArgsConstructor
public class R01MPublishRequest implements R01MPublishModelObject {
    private static final long serialVersionUID = 1430852176106784642L;
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Identificador nico de la publicacin 
	 */
    @Getter @Setter private R01MPublishRequestOID _oid;
	/**
     * Identificador del repositorio de publicacin (destino de publicacin).
     */
    @Getter @Setter private R01MPublishDestinationRepositoryOID _publishRepositoryOid;
    /**
     * Tipo de publicacin/despublicacin
     */
    @Getter @Setter private R01MPublishType _type = R01MPublishType.INMEDIATE_PUB;
	/**
     * Fecha de publicacin o despublicacin
     */
    @Getter @Setter private Date _requestedSchedulledDate = Calendar.getInstance().getTime();;    
    /**
     * Url a la que se invocar cuando halla finalizado la publicacin    
     */
    @Getter @Setter private R01MUrl _callbackUrl = null;    
}
