package r01mo.model.publish;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;
import r01mo.model.oids.publish.R01MPublishDestinationRepositoryOID;
import r01mo.model.publisher.R01MPublisherOperationResult;

/**
 * Informacin sobre el estado de publicacin en un repositorio
 */
@ConvertToDirtyStateTrackable
@Accessors(prefix="_")
@NoArgsConstructor
public class R01MPublishInfo implements R01MPublishModelObject {
    private static final long serialVersionUID = 119970521009922458L;
///////////////////////////////////////////////////////////////////////////////////////////
//  ESTADO
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Identificador del repositorio de publicacin (destino de publicacin).
     */
    @Getter @Setter private R01MPublishDestinationRepositoryOID _repositoryOid;
    /**
     * Datos de la ltima operacin cuya finalizacin con xito ha sido confirmada por el publicador
     * <ul>
     * 		<li>Si la operacin ACTUAL est ejecutndose o ha fallado, esta variable contiene 
     * 			la ltima publicacin / despublicacin correcta</li>
     * 		<li>Si la operacin ACTUAL se ha confirmado correctamente por el publicador, esta variable
     * 			contiene la ANTERIOR publicacin / despublicacin correcta</li>
     * </ul>
     */
    @Getter @Setter private R01MPublisherOperationResult _previousOperation;
    /**
     * Datos de la ltima operacin enviada al publicador 
     */
    @Getter @Setter private R01MPublisherOperationResult _lastOperation;
    
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
///////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Comprueba si el objeto est DESPUBLICADO y hay confirmacin de ello
	 * @return true si se trata de un estado de despublicacin
	 */
	public boolean isUnPublished() {
		boolean outIsUnPublished = false;
		if (_lastOperation != null && _lastOperation.isUnPublished()) {
			outIsUnPublished = true;
		} else if (_lastOperation != null && _previousOperation != null && _previousOperation.isUnPublished()) {
			outIsUnPublished = true;
		}
		return outIsUnPublished;
	}
	/**
	 * Comprueba si el objeto est DESPUBLICADO y hay confirmacin de ello
	 * @return true si se trata de un estado de despublicacin
	 */
	public boolean isPublished() {
		boolean outIsPublished = false;
		if (_lastOperation != null && _lastOperation.isPublished()) {
			outIsPublished = true;
		} else if (_lastOperation != null && _previousOperation != null && _previousOperation.isPublished()) {
			outIsPublished = true;
		}
		return outIsPublished;
	}
}
