package r01mo.model.oids.structures;

import r01f.types.annotations.Inmutable;
import r01mo.model.oids.R01MOID;


/**
 * OID de una versin de las selecciones de etiquetas en estructuras
 * 		En un contenido / portal se puede crear una versin de las selecciones en un momento dado, en un 
 *  	concepto similar a un snapshot (foto) del estado de catalogacin del contenido / portal
 *  	Estas "fotos" de la catalogacin normalmente se hacen cuando se hace una versin de una estructura
 *  	y un contenido est catalogado en esta estructua
 */
@Inmutable
public class R01MLabelInStructurePicksSnapshotOID extends R01MOID {
	private static final long serialVersionUID = -2727859776371512718L;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
///////////////////////////////////////////////////////////////////////////////////////////
	public R01MLabelInStructurePicksSnapshotOID(final String oid) {
		super(oid);
	}
///////////////////////////////////////////////////////////////////////////////
//  CONSTRUCCIN DE OBJETOS
///////////////////////////////////////////////////////////////////////////////
	public static R01MLabelInStructurePicksSnapshotOID forId(final String id) {
		return new R01MLabelInStructurePicksSnapshotOID(id);
	}
	public static R01MLabelInStructurePicksSnapshotOID supply() {
		return R01MLabelInStructurePicksSnapshotOID.forId(R01MOID.supplyOid());
	}
}
