package r01mo.model.oids.publish;

import r01f.types.annotations.Inmutable;
import r01mo.model.oids.R01MOID;


/**
 * OID de un repositorio de publicacin
 */
@Inmutable
public class R01MPublishDestinationRepositoryOID extends R01MOID {
	private static final long serialVersionUID = -6291130534743233006L;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
///////////////////////////////////////////////////////////////////////////////////////////
	public R01MPublishDestinationRepositoryOID(final String oid) {
		super(oid);
	}
///////////////////////////////////////////////////////////////////////////////
//  CONSTRUCCIN DE OBJETOS
///////////////////////////////////////////////////////////////////////////////
	public static R01MPublishDestinationRepositoryOID forId(final String id) {
		return new R01MPublishDestinationRepositoryOID(id);
	}
	public static R01MPublishDestinationRepositoryOID supply() {
		return R01MPublishDestinationRepositoryOID.forId(R01MOID.supplyOid());
	}
	public static R01MPublishDestinationRepositoryOID anyRepository() {
		return R01MPublishDestinationRepositoryOID.forId("r01mAnyPubRepository");
	}
}
