package r01mo.model.oids.geo;

import r01f.types.annotations.Inmutable;


/**
 * Cdigo identificador de una localidad
 * <pre>
 * Country
 *   |_Territory 
 *   	 |_State
 *   		 |_Locality
 *   			|_Municipality
 *   				|_District
 *   					|_Street
 * </pre>
 */
@Inmutable
public class R01MGeoTerritoryOID extends R01MGeoOID {
	private static final long serialVersionUID = -5811800490034132576L;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
///////////////////////////////////////////////////////////////////////////////////////////
	public R01MGeoTerritoryOID(final long oid) {
		super(oid);
	}
///////////////////////////////////////////////////////////////////////////////
//  CONSTRUCCIN DE OBJETOS
///////////////////////////////////////////////////////////////////////////////
	public static R01MGeoTerritoryOID forId(final long id) {
		return new R01MGeoTerritoryOID(id);
	}
}
