package r01mo.model.oids.geo;

import r01f.types.annotations.Inmutable;


/**
 * Cdigo identificador de una calle
 * <pre>
 * Country
 *   |_Territory 
 *   	 |_State
 *   		 |_Locality
 *   			|_Municipality
 *   				|_District
 *   					|_Street
 * </pre>
 */
@Inmutable
public class R01MGeoStreetOID extends R01MGeoOID {
	private static final long serialVersionUID = 8671822814362300783L;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
///////////////////////////////////////////////////////////////////////////////////////////
	public R01MGeoStreetOID(final long oid) {
		super(oid);
	}
///////////////////////////////////////////////////////////////////////////////
//  CONSTRUCCIN DE OBJETOS
///////////////////////////////////////////////////////////////////////////////
	public static R01MGeoStreetOID forId(final long id) {
		return new R01MGeoStreetOID(id);
	}
}
