package r01mo.model.oids.geo;

import r01f.types.annotations.Inmutable;


/**
 * Cdigo identificador de un estado
 * <pre>
 * Country
 *   |_Territory 
 *   	 |_State
 *   		 |_Locality
 *   			|_Municipality
 *   				|_District
 *   					|_Street
 * </pre>
 */
@Inmutable
public class R01MGeoStateOID extends R01MGeoOID {
	private static final long serialVersionUID = -7636328071565337389L;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
///////////////////////////////////////////////////////////////////////////////////////////
	public R01MGeoStateOID(final long oid) {
		super(oid);
	}
///////////////////////////////////////////////////////////////////////////////
//  CONSTRUCCIN DE OBJETOS
///////////////////////////////////////////////////////////////////////////////
	public static R01MGeoStateOID forId(final long id) {
		return new R01MGeoStateOID(id);
	}
}
