package r01mo.model.oids.geo;

import r01f.types.annotations.Inmutable;


/**
 * Cdigo identificador de un estado
 * <pre>
 * Country
 *   |_Territory 
 *   	 |_State
 *   		 |_Locality
 *   			|_Municipality
 *   				|_District
 *   					|_Street
 * </pre>
 */
@Inmutable
public class R01MGeoLocalityOID extends R01MGeoOID {
	private static final long serialVersionUID = 8445129300980606911L;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
///////////////////////////////////////////////////////////////////////////////////////////
	public R01MGeoLocalityOID(final long oid) {
		super(oid);
	}
///////////////////////////////////////////////////////////////////////////////
//  CONSTRUCCIN DE OBJETOS
///////////////////////////////////////////////////////////////////////////////
	public static R01MGeoLocalityOID forId(final long id) {
		return new R01MGeoLocalityOID(id);
	}
}
