package r01mo.model.oids.geo;

import r01f.types.annotations.Inmutable;


/**
 * Cdigo identificador de un municipio
 * <pre>
 * Country
 *   |_Territory 
 *   	 |_State
 *   		 |_Locality
 *   			|_Municipality
 *   				|_District
 *   					|_Street
 * </pre>
 */
@Inmutable
public class R01MGeoDistrictOID extends R01MGeoOID {
	private static final long serialVersionUID = -8855341000465307541L;
///////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
///////////////////////////////////////////////////////////////////////////////////////////
	public R01MGeoDistrictOID(final long oid) {
		super(oid);
	}
///////////////////////////////////////////////////////////////////////////////
//  CONSTRUCCIN DE OBJETOS
///////////////////////////////////////////////////////////////////////////////
	public static R01MGeoDistrictOID forId(final long id) {
		return new R01MGeoDistrictOID(id);
	}
}
