package r01mo.model.oids;

import r01f.guids.OID;
import r01f.types.annotations.Inmutable;
import r01mo.common.internal.R01M;

/**
 * Base para todos los OIDs de R01M
 */
@Inmutable
public abstract class R01MOID extends OID<String> {
	private static final long serialVersionUID = 4449032738491944411L;
///////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
///////////////////////////////////////////////////////////////////////////////
	public R01MOID(final String id) {
		super(id);
	}
///////////////////////////////////////////////////////////////////////////////
//  METODOS ESTATICOS
///////////////////////////////////////////////////////////////////////////////
	/**
	 * Genera un oid para un objeto del modelo
	 * @return el oid del objeto del modelo
	 */
	protected static String supplyOid() {
		return R01M.generateGUID();
	}
}
