package r01mo.model.editionstatus;

import java.util.Map;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;
import r01mo.model.oids.R01MEditionCommentOID;

/**
 * Informacin sobre el estado de edicin
 */
@ConvertToDirtyStateTrackable
@Accessors(prefix="_")
@NoArgsConstructor
public class R01MEditionStatusInfo implements R01MEditionStatusModelObject {
	private static final long serialVersionUID = 3354345618660047024L;
///////////////////////////////////////////////////////////////////////////////////////////
//  ESTADO
///////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Fecha de la ltima modificacin
	 */
	@Getter @Setter private Map<R01MEditionCommentOID,R01MEditionComment> _editionComments;
	/**
	 * Informacin sobre el flujo de aprobacin
	 */
	@Getter @Setter private R01MEditionApprovalInfo _approvalInfo;
/////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * @return true si se est en edicin
	 */
	public boolean isInEditionStatus() {
		return _approvalInfo == null || _approvalInfo.getStatus() == R01MApprovalStatus.EDITING;
	}
	/**
	 * @return true si se est aprobado
	 */
	public boolean isInApprovedStatus() {
		return _approvalInfo != null && _approvalInfo.getStatus() == R01MApprovalStatus.APPROVED;
	}
	/**
	 * @return true si hay aprobaciones pendientes
	 */
	public boolean areTherePendingApprovals() {
		return _approvalInfo != null && _approvalInfo.getStatus() == R01MApprovalStatus.APPROVAL_PENDING;
	}
	/**
	 * @return true si est rechazado
	 */
	public boolean isInRejectedStatus() {
		return _approvalInfo != null && _approvalInfo.getStatus() == R01MApprovalStatus.REJECTED;
	}
}
