package r01mo.model.editionstatus;

import java.util.Date;

import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;
import r01mo.model.R01MUserCode;
import r01mo.model.oids.R01MEditionCommentOID;

/**
 * Comentario dejado por algn usuario en el proceso de edicin / aprobacin
 */
@ConvertToDirtyStateTrackable
@Accessors(prefix="_")
@NoArgsConstructor
public class R01MEditionComment implements R01MEditionStatusModelObject {
	private static final long serialVersionUID = 635030063701425466L;
/////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Identificador
	 */
	private R01MEditionCommentOID _oid;
	/**
	 * Fecha del comentario
	 */
	private Date _date;
	/**
	 * Autor del comentario
	 */
	private R01MUserCode _author;
	/**
	 * Comentario
	 */
	private String _comment;
}
