package r01mo.model.editionstatus;

import static r01mo.model.editionstatus.R01MApprovalStatus.APPROVAL_PENDING;
import static r01mo.model.editionstatus.R01MApprovalStatus.APPROVED;
import static r01mo.model.editionstatus.R01MApprovalStatus.EDITING;
import static r01mo.model.editionstatus.R01MApprovalStatus.REJECTED;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

/**
 * Estado de revisin.
 * El flujo de revisin es:
 * <pre>
 *  Redaccin / Rechazado <----| <-----------------|
 *           |                 |                   |
 *     [Autor:Terminar] [Revisor:Rechazar]         |
 *           |                 |                   |
 *   Pendiente de Revision ----|                   |
 *           |                                     |
 *   [Revisor:Aprobar]                       [Autor:Modificar]
 *           |                                     |
 *        Revisado---------------------------------|
 * </pre>
 */
@ConvertToDirtyStateTrackable
@Accessors(prefix="_")
@NoArgsConstructor
public class R01MEditionApprovalInfo implements R01MEditionStatusModelObject {
    private static final long serialVersionUID = 4715188035875114376L;
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Estado del documento
     */
    @Getter private R01MApprovalStatus _status = EDITING;
    /**
     * Nmero de revisiones (aprobaciones) pendientes
     */
    @Getter private int _remainingApprovals = -1;
    /**
     * Nmero de revisiones (aprobaciones necesarias)
     */
    @Getter private int _neededApprovals = -1;
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
///////////////////////////////////////////////////////////////////////////////////////////
    public void changeToEditing() {
    	_status = EDITING;
    	_remainingApprovals = -1;
    }
    public void moveToApprovalPending(final int numberOfApprovalsNeeded) {
    	if (!_status.isIn(EDITING,REJECTED)) throw new IllegalStateException("NO se puede pasar al estado 'pendiente de aprobacin' si NO se est en el estado de 'en redaccin");
    	_neededApprovals = numberOfApprovalsNeeded;
    	_status = APPROVAL_PENDING;	// Pasar al estado de "Pendiente de X aprobaciones"
    	_remainingApprovals = numberOfApprovalsNeeded;
    }
    public void addApproval() {
    	if (_status != APPROVAL_PENDING) throw new IllegalStateException("NO se puede aprobar si el estado NO es 'pendiente de X aprobaciones'");
    	_remainingApprovals--;
    	if (_remainingApprovals == 0) _status = APPROVED;	// si se han dado todas las aprobaciones necesarias, pasar al estado de "APROBADO"
    }
    public void reject() {
    	if (!_status.isIn(APPROVAL_PENDING,REJECTED)) throw new IllegalStateException("NO se puede rechazar si el estado NO es 'pendiente de X aprobaciones' o 'rechazado'");
    	_remainingApprovals = _neededApprovals;		// Reiniciar el contador de aprobaciones necesarias
    	_status = REJECTED;
    }
}
