package r01mo.model.editionstatus;

import r01f.enums.EnumExtended;
import r01f.enums.EnumExtendedWrapper;

/**
 * Estados de revisin
 */
public enum R01MApprovalStatus implements EnumExtended<R01MApprovalStatus> {
	EDITING,			// En edicin
	APPROVAL_PENDING,	// Pendiente de aprobacin
	REJECTED,			// Rechazado
	APPROVED;			// Aprobado

/////////////////////////////////////////////////////////////////////////////////////////
//  INTERFAZ EnumExtended
/////////////////////////////////////////////////////////////////////////////////////////
	private static EnumExtendedWrapper<R01MApprovalStatus> _enums = new EnumExtendedWrapper<R01MApprovalStatus>(R01MApprovalStatus.values());

	@Override
	public boolean isIn(R01MApprovalStatus... status) {
		return _enums.isIn(this,status);
	}
	@Override
	public boolean is(R01MApprovalStatus other) {
		return _enums.is(this,other);
	}	
}
