package r01mo.model.assets.gallery;

import java.util.HashMap;
import java.util.Map;

import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;
import r01f.types.Path;
import r01mo.model.asset.R01MAssetLocated;
import r01mo.model.asset.R01MVideoAsset;
import r01mo.model.oids.assets.R01MAssetsGalleryItemOID;

/**
 * Galera de videos
 * @param <A> el tipo del asset localizado 
 * 			  <pre>
 * 				- {@link r01mo.model.asset.R01MAssetContentLangVersionLocated}<R01MVideoAsset>
 * 				- {@link r01mo.model.asset.R01MAssetContentLocated}<R01MVideoAsset>
 * 				- {@link r01mo.model.asset.R01MAssetPortalLocated})<R01MVideoAsset>
 * 			  </pre>
 * <code>
 *		// [1] Crear el Asset localizado en un contenido
 *		R01MAssetContentLocated<R01MVideoAsset> videoAssetInContent = new R01MAssetContentLocated<R01MVideoAsset>();
 *		videoAssetInContent.setAssetData(...);
 *		videoAssetInContent.setPath(R01MContentRelativePath.of("/resources/videos/myVideo.flv"));
 *	
 *		// [2] Crear el Item de la galera de tipo R01MVideoAsset
 *		R01MAssetsGalleryVideoItem<R01MAssetContentLocated<R01MVideoAsset>> videoItem = new R01MAssetsGalleryVideoItem<R01MAssetContentLocated<R01MVideoAsset>>();
 *		videoItem.setAsset(videoAssetInContent);
 *	
 *		// [3] Crear la galera y aadir los items
 *		R01MVideosGallery gallery = new R01MVideosGallery();
 *		gallery.addVideoAsset(videoItem);
 * </code>
 */
@ConvertToDirtyStateTrackable
@Accessors(prefix="_")
@NoArgsConstructor
public class R01MVideosGallery extends R01MAssetsGalleryBase<R01MAssetsGalleryVideoItem<? extends R01MAssetLocated<R01MVideoAsset,
																												   ? extends Path>>> {
	private static final long serialVersionUID = 4415657255905917380L;

/////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Aade un asset de tipo video a la galera
	 * @param theVideo el video
	 * @return la galera
	 */
	public R01MVideosGallery addVideoAsset(final R01MAssetsGalleryVideoItem<? extends R01MAssetLocated<R01MVideoAsset,? extends Path>> theVideo) {
		Map<R01MAssetsGalleryItemOID,R01MAssetsGalleryVideoItem<? extends R01MAssetLocated<R01MVideoAsset,? extends Path>>> items = this.getItems();
		if (items == null) items = new HashMap<R01MAssetsGalleryItemOID,R01MAssetsGalleryVideoItem<? extends R01MAssetLocated<R01MVideoAsset,? extends Path>>>();
		items.put(R01MAssetsGalleryItemOID.supply(),theVideo);
		return this;
	}
	/**
	 * Aade un asset de tipo video a la galera
	 * @param theVideo el video
	 * @return la galera
	 */
	public R01MVideosGallery addVideoAsset(final R01MAssetLocated<R01MVideoAsset,? extends Path> theVideo) {
		R01MAssetsGalleryVideoItem<R01MAssetLocated<R01MVideoAsset,? extends Path>> item = new R01MAssetsGalleryVideoItem<R01MAssetLocated<R01MVideoAsset,? extends Path>>(theVideo);
		this.addVideoAsset(item);
		return this;
	}	
}
