package r01mo.model.assets.gallery;

import java.util.HashMap;
import java.util.Map;

import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;
import r01f.types.Path;
import r01mo.model.asset.R01MAssetLocated;
import r01mo.model.asset.R01MImageAsset;
import r01mo.model.oids.assets.R01MAssetsGalleryItemOID;

/**
 * Galera de imgenes
 * @param <A> el tipo del asset localizado 
 * 			  <pre>
 * 				- {@link r01mo.model.asset.R01MAssetContentLangVersionLocated}<R01MImageAsset>
 * 				- {@link r01mo.model.asset.R01MAssetContentLocated}<R01MImageAsset>
 * 				- {@link r01mo.model.asset.R01MAssetPortalLocated})<R01MImageAsset>
 * 			  </pre>
 * <code>
 *		// [1] Crear el Asset localizado en un contenido
 *		R01MAssetContentLocated<R01MImageAsset> imgAssetInContent = new R01MAssetContentLocated<R01MImageAsset>();
 *		imgAssetInContent.setAssetData(...);
 *		imgAssetInContent.setPath(R01MContentRelativePath.of("/resources/images/myImage.jpg"));
 *	
 *		// [2] Crear el Item de la galera de tipo R01MImageAsset
 *		R01MAssetsGallerImageItem<R01MAssetContentLocated<R01MImageAsset>> imgItem = new R01MAssetsGalleryImageItem<R01MAssetContentLocated<R01MImageAsset>>();
 *		imgItem.setAsset(imgAssetInContent);
 *	
 *		// [3] Crear la galera y aadir los items
 *		R01MImagesGallery gallery = new R01MImagesGallery();
 *		gallery.addImageAsset(imgItem);
 * </code>
 */
@ConvertToDirtyStateTrackable
@Accessors(prefix="_")
@NoArgsConstructor
public class R01MImagesGallery extends R01MAssetsGalleryBase<R01MAssetsGalleryImageItem<? extends R01MAssetLocated<R01MImageAsset,
																												   ? extends Path>>> {
	private static final long serialVersionUID = -2419691087481823808L;
/////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Aade un asset de tipo imagen a la galera
	 * @param theImage la imagen
	 * @return la galera
	 */
	public R01MImagesGallery addImageAsset(final R01MAssetsGalleryImageItem<? extends R01MAssetLocated<R01MImageAsset,? extends Path>> theImage) {
		Map<R01MAssetsGalleryItemOID,R01MAssetsGalleryImageItem<? extends R01MAssetLocated<R01MImageAsset,? extends Path>>> items = this.getItems();
		if (items == null) items = new HashMap<R01MAssetsGalleryItemOID,R01MAssetsGalleryImageItem<? extends R01MAssetLocated<R01MImageAsset,? extends Path>>>();
		items.put(R01MAssetsGalleryItemOID.supply(),theImage);
		return this;
	}
	/**
	 * Aade un asset de tipo imagen a la galera
	 * @param theImage la imagen
	 * @return la galera
	 */
	public R01MImagesGallery addImageAsset(final R01MAssetLocated<R01MImageAsset,? extends Path> theImage) {
		R01MAssetsGalleryImageItem<R01MAssetLocated<R01MImageAsset,? extends Path>> item = new R01MAssetsGalleryImageItem<R01MAssetLocated<R01MImageAsset,? extends Path>>(theImage);
		this.addImageAsset(item);
		return this;
	}
}
