package r01mo.model.assets.gallery;

import java.util.HashMap;
import java.util.Map;

import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;
import r01f.types.Path;
import r01mo.model.asset.R01MAssetLocated;
import r01mo.model.asset.R01MDocumentAsset;
import r01mo.model.oids.assets.R01MAssetsGalleryItemOID;

/**
 * Galera de imgenes
 * @param <A> el tipo del asset localizado 
 * 			  <pre>
 * 				- {@link r01mo.model.asset.R01MAssetContentLangVersionLocated}<R01MDocumentAsset>
 * 				- {@link r01mo.model.asset.R01MAssetContentLocated}<R01MDocumentAsset>
 * 				- {@link r01mo.model.asset.R01MAssetPortalLocated})<R01MDocumentAsset>
 * 			  </pre>
 * Ejemplo de uso:
 * <code>
 *		// [1] Crear el Asset localizado en un contenido
 *		R01MAssetContentLocated<R01MDocumentAsset> docAssetInContent = new R01MAssetContentLocated<R01MDocumentAsset>();
 *		docAssetInContent.setAssetData(...);
 *		docAssetInContent.setPath(R01MContentRelativePath.of("/resources/attachments/mydoc.pdf"));
 *	
 *		// [2] Crear el Item de la galera de tipo R01MDocumentAsset
 *		R01MAssetsGalleryDocumentItem<R01MAssetContentLocated<R01MDocumentAsset>> docItem = new R01MAssetsGalleryDocumentItem<R01MAssetContentLocated<R01MDocumentAsset>>();
 *		docItem.setAsset(docAssetInContent);
 *	
 *		// [3] Crear la galera y aadir los items
 *		R01MDocumentsGallery gallery = new R01MDocumentsGallery();
 *		gallery.addDocumentAsset(docItem);
 * </code>
 */
@ConvertToDirtyStateTrackable
@Accessors(prefix="_")
@NoArgsConstructor
public class R01MDocumentsGallery extends R01MAssetsGalleryBase<R01MAssetsGalleryDocumentItem<? extends R01MAssetLocated<R01MDocumentAsset,
																														 ? extends Path>>> {
	private static final long serialVersionUID = -2419691087481823808L;
/////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Aade un asset de tipo documento a la galera
	 * @param theDocument el documento
	 * @return la galera
	 */
	public R01MDocumentsGallery addDocumentAsset(final R01MAssetsGalleryDocumentItem<? extends R01MAssetLocated<R01MDocumentAsset,? extends Path>> theDocument) {
		Map<R01MAssetsGalleryItemOID,R01MAssetsGalleryDocumentItem<? extends R01MAssetLocated<R01MDocumentAsset,? extends Path>>> items = this.getItems();
		if (items == null) items = new HashMap<R01MAssetsGalleryItemOID,R01MAssetsGalleryDocumentItem<? extends R01MAssetLocated<R01MDocumentAsset,? extends Path>>>();
		items.put(R01MAssetsGalleryItemOID.forId("GENERATE!!!"),theDocument);
		return this;
	}
	/**
	 * Aade un asset de tipo documento a la galera
	 * @param theDocument el documento
	 * @return la galera
	 */
	public R01MDocumentsGallery addDocumentAsset(final R01MAssetLocated<R01MDocumentAsset,? extends Path> theDocument) {
		R01MAssetsGalleryDocumentItem<R01MAssetLocated<R01MDocumentAsset,? extends Path>> item = new R01MAssetsGalleryDocumentItem<R01MAssetLocated<R01MDocumentAsset,? extends Path>>(theDocument);
		this.addDocumentAsset(item);
		return this;
	}
}
