package r01mo.model.assets.gallery;

import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;
import r01f.types.Path;
import r01mo.model.asset.R01MAssetLocated;
import r01mo.model.asset.R01MVideoAsset;

/**
 * Item de tipo video de una galera
 * @param <A> cualquier asset localizado de tipo video
 * 			  <pre>
 * 				- {@link r01mo.model.asset.R01MAssetContentLocated}<R01MVideoAsset>
 * 				- {@link r01mo.model.asset.R01MAssetContentLangVersionLocated}<R01MVideoAsset>
 * 				- {@link r01mo.model.asset.R01MAssetPortalLocated}<R01MVideoAsset>
 * 			  </pre>
 */
@ConvertToDirtyStateTrackable
@Accessors(prefix="_")
@NoArgsConstructor
public class R01MAssetsGalleryVideoItem<A extends R01MAssetLocated<R01MVideoAsset,
																   ? extends Path>> extends R01MAssetsGalleryItemBase<A> {
	private static final long serialVersionUID = -1808032843403273437L;
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * @param videoAsset el video
	 */
	public R01MAssetsGalleryVideoItem(final A videoAsset) {
		this.setAsset(videoAsset);
	}
}
