package r01mo.model.assets.gallery;

import java.util.Comparator;
import java.util.Map;

import lombok.RequiredArgsConstructor;
import r01mo.model.oids.assets.R01MAssetsGalleryItemOID;

/**
 * Comparador de objetos {@link R01MResourcesGalleryItemBase} en funcin del orden de presentacin
 * utilizado para ordenar los items
 * (ver http://stackoverflow.com/questions/109383/how-to-sort-a-mapkey-value-on-the-values-in-java)
 */
@RequiredArgsConstructor
class R01MAssetsGalleryItemComparatorByPresentationOrder implements Comparator<R01MAssetsGalleryItemOID> {
/////////////////////////////////////////////////////////////////////////////////////////
//  ESTADO
/////////////////////////////////////////////////////////////////////////////////////////	
	private final Map<R01MAssetsGalleryItemOID,? extends R01MAssetsGalleryItemBase<?>> _map;
/////////////////////////////////////////////////////////////////////////////////////////
//  INTERFAZ Comparator
/////////////////////////////////////////////////////////////////////////////////////////
	@Override
	public int compare(R01MAssetsGalleryItemOID item1Oid,
			           R01MAssetsGalleryItemOID item2Oid) {
		if (item1Oid == null && item2Oid == null) return 0;
		if (item1Oid == null && item2Oid != null) return -1;
		if (item1Oid != null && item2Oid == null) return 1;
		
		R01MAssetsGalleryItemBase<?> item1 = _map.get(item1Oid);
		R01MAssetsGalleryItemBase<?> item2 = _map.get(item2Oid);
		
		if (item1 == null && item2 == null) return 0;
		if (item1 == null && item2 != null) return -1;
		if (item1 != null && item2 == null) return 1;
		
		Integer item1PresentationOrder = new Integer(item1.getPresentationOrder());
		Integer item2PresentationOrder = new Integer(item2.getPresentationOrder());
		return item1PresentationOrder.compareTo(item2PresentationOrder);
	}
}
