package r01mo.model.assets.gallery;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;
import r01f.types.Path;
import r01mo.model.asset.R01MAssetBase;
import r01mo.model.asset.R01MAssetLocated;
import r01mo.model.asset.R01MAssetModelObject;
import r01mo.model.asset.features.R01MAssetFeatures;
import r01mo.model.oids.assets.R01MAssetsGalleryItemOID;

/**
 * Clase base a ser extendida por todos los items de una galera de recursos
 * @param <ASSET> un asset localizado
 * 				  {@link r01mo.model.asset.R01MAssetContentLocated}, 
 * 				  {@link r01mo.model.asset.R01MAssetContentLangVersionLocated}, 
 * 				  {@link r01mo.model.asset.R01MAssetPortalLocated}, etc
 */
@ConvertToDirtyStateTrackable
@Accessors(prefix = "_")
@NoArgsConstructor
abstract class R01MAssetsGalleryItemBase<A extends R01MAssetLocated<? extends R01MAssetBase<? extends R01MAssetFeatures>,
																	? extends Path>> implements R01MAssetModelObject {
	private static final long serialVersionUID = -4128310582295145820L;
/////////////////////////////////////////////////////////////////////////////////////////
// ESTADO
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Identificador del recurso
	 */
	@Getter @Setter private R01MAssetsGalleryItemOID _oid;
	/**
	 * Indica si los recursos deben mostrarse o no en la presentacin por
	 * defecto. 
	 * Cuando se lanza el renderizado por defecto y este atributo esta
	 * a false el recurso no se visualiza.
	 */
	@Getter @Setter private boolean _showByDefaultRendering = true;
	/**
	 * Orden de pintado del recurso en la presentacin.
	 */
	@Getter @Setter private int _presentationOrder = 0;
	/**
	 * Asset incluido en la galera
	 */
	@Getter @Setter private A _asset;
	/**
	 * Caption del recurso
	 */
	@Getter @Setter private String _title;
	/**
	 * Texto alternativo
	 */
	@Getter @Setter private String _description;	
}
