package r01mo.model.assets.gallery;

import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;
import r01f.types.Path;
import r01mo.model.asset.R01MAssetLocated;
import r01mo.model.asset.R01MImageAsset;

/**
 * Item de tipo imagen de una galera
 * @param <A> cualquier asset localizado de tipo imagen
 * 			  <pre>
 * 				- {@link r01mo.model.asset.R01MAssetContentLocated}<R01MImageAsset>
 * 				- {@link r01mo.model.asset.R01MAssetContentLangVersionLocated}<R01MImageAsset>
 * 				- {@link r01mo.model.asset.R01MAssetPortalLocated}<R01MImageAsset>
 * 			  </pre>
 */
@ConvertToDirtyStateTrackable
@Accessors(prefix="_")
@NoArgsConstructor
public class R01MAssetsGalleryImageItem<A extends R01MAssetLocated<R01MImageAsset,
																   ? extends Path>> extends R01MAssetsGalleryItemBase<A> {
	private static final long serialVersionUID = -1622650482048879151L;
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * @param image la imagen
	 */
	public R01MAssetsGalleryImageItem(final A imageAsset) {
		this.setAsset(imageAsset);
	}
}
