package r01mo.model.assets.gallery;

import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;
import r01f.types.Path;
import r01mo.model.asset.R01MAssetLocated;
import r01mo.model.asset.R01MDocumentAsset;

/**
 * Item de tipo documento de una galera
 * @param <A> cualquier asset localizado de tipo documento
 * 			  <pre>
 * 				- {@link r01mo.model.asset.R01MAssetContentLocated}<R01MDocumentAsset>
 * 				- {@link r01mo.model.asset.R01MAssetContentLangVersionLocated}<R01MDocumentAsset>
 * 				- {@link r01mo.model.asset.R01MAssetPortalLocated}<R01MDocumentAsset>
 * 			  </pre>
 */
@ConvertToDirtyStateTrackable
@Accessors(prefix="_")
@NoArgsConstructor
public class R01MAssetsGalleryDocumentItem<A extends R01MAssetLocated<R01MDocumentAsset,
																	  ? extends Path>> extends R01MAssetsGalleryItemBase<A> {
	private static final long serialVersionUID = -3781849307620546566L;
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * @param documentAsset el document
	 */
	public R01MAssetsGalleryDocumentItem(final A documentAsset) {
		this.setAsset(documentAsset);
	}
}
