package r01mo.model.asset.features;

import java.util.regex.Pattern;

import lombok.Getter;
import lombok.experimental.Accessors;
import r01f.enums.EnumWithRegEx;
import r01f.enums.EnumWithRegExWrapper;

/**
 * Formato de video
 */
@Accessors(prefix="_")
public enum R01MVideoFormat implements EnumWithRegEx<R01MVideoFormat> {
	FLV(Pattern.compile(".+\\.flv")),
	MOV(Pattern.compile(".+\\.mov"));

	@Getter private final Pattern[] _patterns;
	private R01MVideoFormat(Pattern... patterns) {
		_patterns = patterns;
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  INTERFAZ EnumWithRegEx
/////////////////////////////////////////////////////////////////////////////////////////
	private static EnumWithRegExWrapper<R01MVideoFormat> _enums = new EnumWithRegExWrapper<R01MVideoFormat>(R01MVideoFormat.values());
	
	@Override
	public boolean isIn(R01MVideoFormat... other) {
		return _enums.isIn(this,other);
	}
	@Override
	public boolean is(R01MVideoFormat other) {
		return _enums.is(this,other);
	}
	@Override
	public boolean canBeFrom(String url) {
		return _enums.canBeFrom(url);
	}
}
