package r01mo.model.asset.features;

import java.util.regex.Pattern;

import lombok.Getter;
import lombok.experimental.Accessors;
import r01f.enums.EnumWithRegEx;
import r01f.enums.EnumWithRegExWrapper;

/**
 * Formato de imagen
 */
@Accessors(prefix="_")
public enum R01MImageFormat implements EnumWithRegEx<R01MImageFormat> {
	JPG(Pattern.compile(".+\\.jpg")),
	GIF(Pattern.compile(".+\\.gif")),
	BMP(Pattern.compile(".+\\.bmp")),
	RAW(Pattern.compile(".+\\.raw"));

	@Getter private final Pattern[] _patterns;
	private R01MImageFormat(Pattern... patterns) {
		_patterns = patterns;
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  INTERFAZ EnumWithRegEx
/////////////////////////////////////////////////////////////////////////////////////////
	private static EnumWithRegExWrapper<R01MImageFormat> _enums = new EnumWithRegExWrapper<R01MImageFormat>(R01MImageFormat.values());
	
	@Override
	public boolean isIn(R01MImageFormat... other) {
		return _enums.isIn(this,other);
	}
	@Override
	public boolean is(R01MImageFormat other) {
		return _enums.is(this,other);
	}
	@Override
	public boolean canBeFrom(String url) {
		return _enums.canBeFrom(url);
	}
}
