package r01mo.model.asset.features;

import java.util.regex.Pattern;

import lombok.Getter;
import lombok.experimental.Accessors;
import r01f.enums.EnumWithRegEx;
import r01f.enums.EnumWithRegExWrapper;

/**
 * Formato de documento
 */
@Accessors(prefix="_")
public enum R01MDocumentFormat implements EnumWithRegEx<R01MDocumentFormat> {
	DOC(Pattern.compile(".+\\.doc"),Pattern.compile(".+\\.docx")),
	SPREADSHEET(Pattern.compile(".+\\.xls"),Pattern.compile(".+\\.xlsx")),
	PRESENTATION(Pattern.compile(".+\\.ppt"),Pattern.compile(".+\\.pptx")),
	DIAGRAM(Pattern.compile(".+\\.vsd")),
	PDF(Pattern.compile(".+\\.pdf"));

	@Getter private final Pattern[] _patterns;
	private R01MDocumentFormat(Pattern... patterns) {
		_patterns = patterns;
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  INTERFAZ EnumWithRegEx
/////////////////////////////////////////////////////////////////////////////////////////
	private static EnumWithRegExWrapper<R01MDocumentFormat> _enums = new EnumWithRegExWrapper<R01MDocumentFormat>(R01MDocumentFormat.values());
	
	@Override
	public boolean isIn(R01MDocumentFormat... other) {
		return _enums.isIn(this,other);
	}
	@Override
	public boolean is(R01MDocumentFormat other) {
		return _enums.is(this,other);
	}
	@Override
	public boolean canBeFrom(String url) {
		return _enums.canBeFrom(url);
	}
}
