package r01mo.model.asset.features;

import java.util.Date;

import r01mo.model.asset.R01MAssetModelObject;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * Caractersticas de una imagen
 */
@Accessors(prefix="_")
@NoArgsConstructor
public class R01MAssetFeatures implements R01MAssetModelObject {
	private static final long serialVersionUID = -4127119641749101108L;
/////////////////////////////////////////////////////////////////////////////////////////
//  ESTADO
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Propietario
	 */
	@Getter @Setter private String _owner;
	/**
	 * Autor
	 */
	@Getter @Setter private String _author;
	/**
	 * Informacin de reutilizacin
	 */
	@Getter @Setter private R01MAssetReuseInfo _reuseInfo;
	/**
	 * Fecha de creacin
	 */
	@Getter @Setter private Date _createDate;
	/**
	 * Tamao en bytes
	 */
	@Getter @Setter private int _sizeInBytes;
}
