package r01mo.model.asset;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import r01mo.model.asset.features.R01MImageFeatures;
import r01mo.paths.R01MContentLangVersionRelativePath;

/**
 * Representa un ThumbNail (imagen de miniatura) de un asset
 */
@Accessors(prefix="_")
@NoArgsConstructor
public class R01MAssetThumbNail implements R01MAssetModelObject {
	private static final long serialVersionUID = 6218315946955307588L;
/////////////////////////////////////////////////////////////////////////////////////////
//  ESTADO
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Path de la imagen relativa al contenido donde se encuentra el asset
	 * al que se refiere el thumbnail
	 */
	@Getter @Setter private R01MContentLangVersionRelativePath _path;
	/**
	 * Nombre de la imagen (normalmente el ttulo de la imagen)
	 */
	@Getter @Setter private String _name;
	/**
	 * Descripcin de la imagen (normalmente el alt de la imagen)
	 */
	@Getter @Setter private String _description;
	/**
	 * Dimensiones del objeto (width / height)
	 */
	@Getter @Setter private R01MImageFeatures _features;
}
