package r01mo.model.asset;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;
import r01mo.model.asset.features.R01MAssetFeatures;
import r01mo.paths.R01MPortalRelativePath;

/**
 * Asset localizado: informacin de un asset pero con localizacin
 * Lo normal es utilizar as:
 * <code>
 * 		R01MAssetContentLocated<R01MImageAsset> asset = new R01MAssetContentLocated<R01MImageAsset>();
 * 		asset.getAsset().getAuthor();
 * 		...
 * </code>
 * @param <A> el tipo del asset (ej: {@link R01MImageAsset}, {@link R01MDocumentAsset}, {@link R01MVideoAsset}, etc)
 */
@ConvertToDirtyStateTrackable
@Accessors(prefix="_")
@NoArgsConstructor
public class R01MAssetPortalLocated<ASSET extends R01MAssetBase<? extends R01MAssetFeatures>> implements R01MAssetLocated<ASSET,R01MPortalRelativePath>,
																										 R01MAssetModelObject {
	private static final long serialVersionUID = 1885216034071894703L;
/////////////////////////////////////////////////////////////////////////////////////////
//  ESTADO
/////////////////////////////////////////////////////////////////////////////////////////	
	/**
	 * Informacin del asset
	 */
	@Getter @Setter private ASSET _assetData;
	/**
	 * Path relativo al portal del Asset
	 */
	@Getter @Setter private R01MPortalRelativePath _path;
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	public R01MAssetPortalLocated(final ASSET asset) {
		_assetData = asset;
	}
	public R01MAssetPortalLocated(final ASSET asset,final R01MPortalRelativePath path) {
		_assetData = asset;
		_path = path;
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
/////////////////////////////////////////////////////////////////////////////////////////	
	@Override
	public String getFileExtension() {
		return _path != null ? _path.fileExtension()
										   : null;
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  FLUENT-API
/////////////////////////////////////////////////////////////////////////////////////////
	public R01MAssetPortalLocated<ASSET> forAsset(final ASSET asset) {
		_assetData = asset;
		return this;
	}
	public R01MAssetPortalLocated<ASSET> inLocation(final R01MPortalRelativePath path) {
		_path = path;
		return this;
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  FACTORA
/////////////////////////////////////////////////////////////////////////////////////////
	public static R01MAssetPortalLocated<R01MAnyTypeAsset> createFor(R01MAnyTypeAsset anyTypeAsset) {
		R01MAssetPortalLocated<R01MAnyTypeAsset> locAsset = new R01MAssetPortalLocated<R01MAnyTypeAsset>(anyTypeAsset);
		return locAsset;
	}
	public static R01MAssetPortalLocated<R01MImageAsset> createFor(R01MImageAsset imgAsset) {
		R01MAssetPortalLocated<R01MImageAsset> locAsset = new R01MAssetPortalLocated<R01MImageAsset>(imgAsset);
		return locAsset;
	}
	public static R01MAssetPortalLocated<R01MVideoAsset> createFor(R01MVideoAsset videoAsset) {
		R01MAssetPortalLocated<R01MVideoAsset> locAsset = new R01MAssetPortalLocated<R01MVideoAsset>(videoAsset);
		return locAsset;
	}
	public static R01MAssetPortalLocated<R01MDocumentAsset> createFor(R01MDocumentAsset documentAsset) {
		R01MAssetPortalLocated<R01MDocumentAsset> locAsset = new R01MAssetPortalLocated<R01MDocumentAsset>(documentAsset);
		return locAsset;
	}
	public static R01MAssetPortalLocated<R01MOpenDataAsset> createFor(R01MOpenDataAsset openDataAsset) {
		R01MAssetPortalLocated<R01MOpenDataAsset> locAsset = new R01MAssetPortalLocated<R01MOpenDataAsset>(openDataAsset);
		return locAsset;
	}
}
