package r01mo.model.asset;

import r01f.types.Path;
import r01mo.model.asset.features.R01MAssetFeatures;

/**
 * Interfaz que han de implementar los {@link R01MAssetBase} localizados
 * @param <A> el tipo del asset 
 * 			  <pre>
 * 					- {@link R01MImageAsset}
 * 					- {@link R01MDocumentAsset}
 * 					- {@link R01MVideoAsset}
 * 			  </pre>
 * @param <L> el tipo de la localizacin
 * 			  <pre>
 * 				 	- {@link r01mo.paths.R01MContentRelativePath}
 * 					- {@link r01mo.paths.R01MContentLangVersionRelativePath}
 * 					- {@link r01mo.paths.R01MPortalRelativePath}
 * 			  </pre>
 */
public interface R01MAssetLocated<A extends R01MAssetBase<? extends R01MAssetFeatures>,
								  L extends Path> {
	public A getAssetData();
	public void setAssetData(A theAsset);
	public L getPath();
	public void setPath(L thePath);
	public String getFileExtension();
}
