package r01mo.model.asset;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;
import r01mo.model.asset.features.R01MAssetFeatures;
import r01mo.paths.R01MContentLangVersionRelativePath;

/**
 * Asset localizado: informacin de un asset pero con localizacin
 * Lo normal es utilizar as:
 * <code>
 * 		R01MAssetContentLocated<R01MImageAsset> asset = new R01MAssetContentLocated<R01MImageAsset>();
 * 		asset.getAsset().getAuthor();
 * 		...
 * </code>
 * @param <A> el tipo del asset 
 * 			  <pre>
 * 					- {@link R01MImageAsset}
 * 					- {@link R01MDocumentAsset}
 * 					- {@link R01MVideoAsset}
 * 			  </pre>
 */
@ConvertToDirtyStateTrackable
@Accessors(prefix="_")
@NoArgsConstructor
public class R01MAssetContentLangVersionLocated<ASSET extends R01MAssetBase<? extends R01MAssetFeatures>> implements R01MAssetLocated<ASSET,R01MContentLangVersionRelativePath>,
																										 			 R01MAssetModelObject {
	private static final long serialVersionUID = 1576086960943696536L;
/////////////////////////////////////////////////////////////////////////////////////////
//  ESTADO
/////////////////////////////////////////////////////////////////////////////////////////	
	/**
	 * Informacin del asset
	 */
	@Getter @Setter private ASSET _assetData;
	/**
	 * Path relativo al contenido del Asset
	 */
	@Getter @Setter private R01MContentLangVersionRelativePath _path;
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	public R01MAssetContentLangVersionLocated(final ASSET asset) {
		_assetData = asset;
	}
	public R01MAssetContentLangVersionLocated(final ASSET asset,final R01MContentLangVersionRelativePath path) {
		_assetData = asset;
		_path = path;
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
/////////////////////////////////////////////////////////////////////////////////////////	
	@Override
	public String getFileExtension() {
		return _path != null ? _path.fileExtension()
													   : null;
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  FLUENT-API
/////////////////////////////////////////////////////////////////////////////////////////
	public R01MAssetContentLangVersionLocated<ASSET> forAsset(final ASSET asset) {
		_assetData = asset;
		return this;
	}
	public R01MAssetContentLangVersionLocated<ASSET> inLocation(final R01MContentLangVersionRelativePath path) {
		_path = path;
		return this;
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  FACTORA
/////////////////////////////////////////////////////////////////////////////////////////
	public static R01MAssetContentLangVersionLocated<R01MAnyTypeAsset> createFor(R01MAnyTypeAsset anyTypeAsset) {
		R01MAssetContentLangVersionLocated<R01MAnyTypeAsset> locAsset = new R01MAssetContentLangVersionLocated<R01MAnyTypeAsset>(anyTypeAsset);
		return locAsset;
	}
	public static R01MAssetContentLangVersionLocated<R01MImageAsset> createFor(R01MImageAsset imgAsset) {
		R01MAssetContentLangVersionLocated<R01MImageAsset> locAsset = new R01MAssetContentLangVersionLocated<R01MImageAsset>(imgAsset);
		return locAsset;
	}
	public static R01MAssetContentLangVersionLocated<R01MVideoAsset> createFor(R01MVideoAsset videoAsset) {
		R01MAssetContentLangVersionLocated<R01MVideoAsset> locAsset = new R01MAssetContentLangVersionLocated<R01MVideoAsset>(videoAsset);
		return locAsset;
	}
	public static R01MAssetContentLangVersionLocated<R01MDocumentAsset> createFor(R01MDocumentAsset documentAsset) {
		R01MAssetContentLangVersionLocated<R01MDocumentAsset> locAsset = new R01MAssetContentLangVersionLocated<R01MDocumentAsset>(documentAsset);
		return locAsset;
	}
	public static R01MAssetContentLangVersionLocated<R01MOpenDataAsset> createFor(R01MOpenDataAsset openDataAsset) {
		R01MAssetContentLangVersionLocated<R01MOpenDataAsset> locAsset = new R01MAssetContentLangVersionLocated<R01MOpenDataAsset>(openDataAsset);
		return locAsset;
	}
}
