package r01mo.model.asset;

import java.util.Set;

import lombok.Delegate;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;
import r01mo.model.R01MTagList;
import r01mo.model.asset.features.R01MAssetFeatures;
import r01mo.model.url.R01MUrl;

/**
 * Representa un Asset (contenido, entendiendo como tal una imagen, video, documento, etc) del Gestor de Contenidos
 * o del Gestor de Portales
 * Las clases concretas son:
 * <pre>
 * 		- {@link R01MDocumentAsset} asset de tipo documento
 * 		- {@link R01MImageAsset} asset de tipo imagen
 * 		- {@link R01MVideoAsset} asset de tipo video
 * 		- {@link R01MOpenDataAsset} asset de tipo openData
 * </pre>
 * A cualquier asset se pueden asociar
 */
@ConvertToDirtyStateTrackable
@Accessors(prefix="_")
@NoArgsConstructor
public abstract class R01MAssetBase<FEATURES extends R01MAssetFeatures> implements R01MAssetModelObject {
	private static final long serialVersionUID = -448005655443053728L;
/////////////////////////////////////////////////////////////////////////////////////////
// ESTADO
/////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Tipo de asset
	 */
	@Getter @Setter private R01MAssetType _type;
	/**
	 * Caption del recurso
	 */
	@Getter @Setter private String _title;
	/**
	 * Texto alternativo
	 */
	@Getter @Setter private String _description;
	/**
	 * Caractersticas del asset: autor, fecha de creacin, etc
	 * Cada tipo de asset (imagen, video, documento, etc) tiene una implementacin concreta
	 */
	@Getter @Setter private FEATURES _features;
	/**
	 * Url a la que se le redirije al usuario/a para descargar el fichero
	 * Cuando se compone el link de descarga del fichero, al usuario/a se le redirige
	 * a esta URL donde por ejemplo se puede recabar informacin de contacto y una vez
	 * hecho esto redirigir a la descarga del fichero
	 * NOTA: El link final se compone aadiendo a esta URL el parmetro ?R01PassThrough=[URL del adjunto]
	 */
	@Getter @Setter private R01MUrl _preDownloadURL;
	/**
	 * Lista de etiquetas del Asset
	 */
	@Delegate(types=R01MAssetTaggeable.class)
	@Getter @Setter private R01MTagList<String> _tags;
	/**
	 * ThumbNails: imgenes en miniatura para el asset
	 */
	@Getter @Setter private Set<R01MAssetThumbNail> _thumbNails;
}
