package r01mo.model.asset;

import lombok.experimental.Accessors;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;
import r01mo.model.asset.features.R01MAssetFeatures;

/**
 * Asset de cualquier tipo, es decir, puede ser una imagen, un video, un documento, etc.
 * El inconveniente de utilizar este tipo de asset es que NO se pueden especificar
 * "features" particulares de cada uno de los tipos
 */
@ConvertToDirtyStateTrackable
@Accessors(prefix="_")
public class R01MAnyTypeAsset extends R01MAssetBase<R01MAssetFeatures> {
	private static final long serialVersionUID = -3791207682906655986L;
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	public R01MAnyTypeAsset() {
		this.setType(R01MAssetType.ANY);
	}
}
