package r01mo.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import r01f.aspects.dirtytrack.ConvertToDirtyStateTrackable;
import r01mo.model.oids.typo.R01MTypoClusterOID;
import r01mo.model.oids.typo.R01MTypoFamilyOID;
import r01mo.model.oids.typo.R01MTypoTypeOID;
/**
 * Informacin de la tipologa.
 */
@ConvertToDirtyStateTrackable
@Accessors(prefix="_")
@NoArgsConstructor @AllArgsConstructor
public class R01MTypology implements R01MModelObject {
    private static final long serialVersionUID = 6963132638633960753L;
///////////////////////////////////////////////////////////////////////////////////////////
//  MIEMBROS
///////////////////////////////////////////////////////////////////////////////////////////
     /**
      * Cluster al que pertenece el contenido.
      */
     @Getter @Setter private R01MTypoClusterOID _clusterOid;
     /**
      * Familia a la que se asocia el contenido.
      */
     @Getter @Setter private R01MTypoFamilyOID _familyOid;
     /**
      * Tipo de contenido.
      */
     @Getter @Setter private R01MTypoTypeOID _typeOid;
///////////////////////////////////////////////////////////////////////////////////////////
//  METODOS
///////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Obtiene un cdigo mnemotcnico concatenando cada uno de los objetos separados por el carcter "<i>:</i>".
     * @return cluster,familia y tipo.
     */
    public String memoCode() {
        return _clusterOid + ":" + _familyOid + ":" + _typeOid;
    }
    /**
     * Carga la localizacin del cdigo memotcnico
     * @param memoCode el cdigo memotcnico
     */
    public void fromMemoCode(final String memoCode) {
    	if (memoCode == null) return;
    	Pattern p = Pattern.compile("([^:]+):([^:]+):([^:]+)");
    	Matcher m = p.matcher(memoCode);
    	if (m.find()) {
    		_clusterOid = new R01MTypoClusterOID(m.group(1));
    		_familyOid = new R01MTypoFamilyOID(m.group(2));
    		_typeOid = new R01MTypoTypeOID(m.group(3));
    	}
    }
}
